package gov.va.vinci.dart.usr;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestUserManager  extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		// log in as a well known person
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");
		Assert.assertNotNull(token);
		Assert.assertEquals(token.getName(), "DNS");
		Assert.assertEquals(token.getCredentials(), "password");
		Assert.assertEquals(token.getDetails(), "details");
		Assert.assertEquals(token.getPrincipal(), "principal");
		Assert.assertNull(token.getUserPreferences());
		
		CustomAuthentication token2 = DartObjectFactory.getInstance().getUserManager().login(token);
		Assert.assertNotNull(token2);
		Assert.assertEquals(token2.getName(), "DNS");
		Assert.assertEquals(token2.getCredentials(), "password");
		Assert.assertEquals(token2.getDetails(), "details");
		Assert.assertEquals(token2.getPrincipal(), "principal");
		Assert.assertNotNull(token2.getUserPreferences());
		Assert.assertEquals(token2.getUserPreferences().getUserLoginId(), "DNS");
		
	}
	
	@Test
	public void testTwo() throws Exception {

		Person pers = null;
		
		// don't find the unknown person in the database
		try {
			pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive("mugwump");
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		// log in as an unknown person
		CustomAuthentication token = new CustomAuthentication("mugwump", null, "password", "details", "principal");
		DartObjectFactory.getInstance().getUserManager().login(token);

		Assert.assertNotNull(token);
		Assert.assertEquals(token.getName(), "mugwump");
		Assert.assertEquals(token.getCredentials(), "password");
		Assert.assertEquals(token.getDetails(), "details");
		Assert.assertEquals(token.getPrincipal(), "principal");
		Assert.assertNotNull(token.getUserPreferences());
		Assert.assertEquals(token.getUserPreferences().getUserLoginId(), "mugwump");

		// find them in the database?
		pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive("mugwump");
		Assert.assertNotNull(pers);
		Assert.assertEquals(pers.getName(), "mugwump");
		
	}

	@Test
	public void testThree() throws Exception {

		Person pers = null;

		// don't find the unknown person in the database
		try {
			pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive("mugwump");
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		// log in as an unknown person
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");
		DartObjectFactory.getInstance().getUserManager().login(token);
		
		// find them in the database?
		pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive("DNS");
		Assert.assertNotNull(pers);
		Assert.assertEquals(pers.getName(), "DNS");

		// don't find them by the wrong name
		try {
			pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive("DNS");
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
	}

}
